<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Tehnical */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Tehnicals'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tehnical-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'user_id',
            'Type',
            'FabriksNr',
            'AdresseBundesland',
            'AdresseOrt',
            'AdresseStreat',
            'AdressePLZ',
            'AdresseStiege',
            'Baujahr',
            'Hersteller',
            'Nennlast',
            'Personen',
            'Antriebsart',
            'Nenngeschwindigkeit',
            'Haltestellen',
            'Ladestellen',
            'Hubhohe',
            'Gesetzt',
            'Profintervall',
            'Betriebskontrollen',
            'fabric_id',
            'UmbauName',
            'UmbauDate',
            'Umfang:ntext',
            'Letzte',
            'LetzteDate',
            'Notizen:ntext',
            'Fakturenadresse',
            'PreisWP',
            'evaluierungName',
            'evaluierungFristen',
            'ErstelltAm',
            'Zusatz',
            'Notruftel',
            'Schachtart',
            'Anlagentyp',
            'Wartungsart',
            'ObjektNr',
            'UIDNUMMER',
            'Hausverwalter',
            'HausverwalterEmail:email',
            'KontaktVerwalter',
            'send_email_to_coworkers:email',
            'status',
            'lat:ntext',
            'lng:ntext',
            'new_prufungen_date',
            'new_prufungen_date_time',
        ],
    ]) ?>

</div>
