<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\ArrayHelper;
use common\models\Type;
use common\models\User;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\widgets\LinkPager;
$s3_path = S3_PATH;
/* @var $this yii\web\View */
/* @var $searchModel common\models\search\TehinicalFrontendSearch */
/* @var $searchModelGlobal common\models\search\TehinicalGlobalSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = Yii::t('app', 'Anlagen');
$this->params['breadcrumbs'][] = $this->title;

$tehh = $tehnics_all->orderBy("id")->limit(1)->one();

if ( $tehh && $tehh->ObjektNr ) {

    $ObjektNrVisible = 1;
}else {

    $ObjektNrVisible = 0;
}

?>
<div class="tehnical-index">
    <div class="header-content">
        <h1 class="admin-title">Anlagen</h1>
        <div class="button-wrapper">
        </div>
    </div>
    <div class="tehnical-index-desktop coworker-table-view">
        <?php Pjax::begin(); ?>    
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'summary' => '',
                'rowOptions' => function ($model, $key, $index, $grid) {
                    return ['class' => "grid-view-style"];
                },
                'columns' => [
                    [
                        'label' => 'Objekt Nr',
                        'attribute' => 'ObjektNr',
                        'visible' => ( $ObjektNrVisible == 1 ),
                    ],
                    'FabriksNr',
                    'AdressePLZ',
                    'AdresseOrt',
                    'AdresseStreat',
                    'Zusatz',
                    [
                        'attribute' => 'Type',
                        'value' => 'Type',
                        'filter' => Html::activeDropDownList($searchModel, 'Type', ArrayHelper::map(Type::find()->asArray()->all(), 'name', 'name'),['class'=>'form-control','prompt' => 'Select All']),
                    ],
                   /* [
                        'label' => 'Betreiber',
                        'value' => function ($data){ return $data->getUser()->one()->Betreiber; },
                    ],*/
                    // 'Baujahr',
                    // 'Hersteller',
                    // 'Nennlast',
                    // 'Personen',
                    // 'Antriebsart',
                    // 'Nenngeschwindigkeit',
                    // 'Haltestellen',
                    // 'Ladestellen',
                    // 'Hubhohe',
                    // 'Gesetzt',
                    // 'Profintervall',
                    // 'Betriebskontrollen',
                    [
                        'format' => 'raw',
                        'label' => 'View',
                        'value' => function($model, $key, $index, $column) {
                                return Html::a(
                                    'View',
                                    Url::to(['tehnic/view', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['tehnic/view', "id" => $model->id]),
                                        'class'=>'button btn btn-primary btn-block',
                                    ]
                                );
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => 'Download Last PDF',
                        'value' => function($data, $key, $index, $column) {
                            if( $data->PDFExist() ) {

                                return Html::a('PDF', $data->last_generate_PDF(), ['class' => 'btn btn-primary btn-block', 'target'=>'_blank']);
                            } else {
                                return "No PDF";
                            }
                        }
                    ],
                ],
            ]); ?>
        <?php Pjax::end(); ?>
    </div>
</div>
<div class="tehnical-index-mobile">
    <?php if( count($tehnics->getModels()) > 0 ): ?>
        <?php $form = ActiveForm::begin([
                'action' => ['index'],
                'method' => 'get',
            ]); ?>
            <label>Bitte geben Sie hier Ihren Suchbegriff ein, um nach einer Anlage zu suchen:</label>
            <?= $form->field($searchModelGlobal, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
            <div class="form-group">
                <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
            </div>
        <?php ActiveForm::end(); ?>
    <?php endif ?>
    <?php Pjax::begin(); ?> 
        <?php foreach ($tehnics->getModels() as $key => $model ): ?>
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <?php if( $model->ObjektNr ): ?>
                        <tr>
                            <td>Objekt Nr</td>
                            <td><?= $model->ObjektNr ?></td>
                        </tr>                    
                    <?php endif ?>
                    <tr>
                        <td>Fabriks Nr</td>
                        <td><?= $model->FabriksNr ?></td>
                    </tr>
                    <tr>
                        <td>PLZ</td>
                        <td><?= $model->AdressePLZ ?></td>
                    </tr>
                    <tr>
                        <td>Ort</td>
                        <td><?= $model->AdresseOrt ?></td>
                    </tr>
                    <tr>
                        <td>Strasse</td>
                        <td><?= $model->AdresseStreat ?></td>
                    </tr>
                    <tr>
                        <td>Zusatz</td>
                        <td><?= $model->Zusatz ?></td>
                    </tr>
                    <tr>
                        <td>Type</td>
                        <td><?= $model->Type ?></td>
                    </tr>
                    <?php if ( $model->type2 ): ?>
                        <tr>
                            <td>Type 2</td>
                            <td><?= $model->type2 ?></td>
                        </tr>
                    <?php endif ?>
                    <tr>
                        <td>Download Last PDF</td>
                        <?php if( $model->PDFExist() ): ?> 
                            <td><?= Html::a('PDF', $model->last_generate_PDF(), ['class' => 'btn btn-block btn-primary', 'target'=>'_blank']) ?></td>
                        <?php else: ?>
                            <td>No PDF</td>
                        <?php endif ?>
                    </tr>
                    <tr>
                        <td>View</td>
                        <td><?= Html::a('View', ['tehnic/view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endforeach ?>
        <div class="pagination">
            <?php
                echo LinkPager::widget([
                'pagination' => $tehnics->pagination,
            ]); ?>
        </div>
    <?php Pjax::end(); ?>
</div>