<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\spinner\Spinner;
/* @var $this yii\web\View */
/* @var $searchModel common\models\search\TehinicalSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Benutzer');
$this->params['breadcrumbs'][] = $this->title;


?>

<div class="header-content">
    <h1 class="admin-title">Benutzer</h1>
    <div class="button-wrapper">
        <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['new'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Neuen Benutzer anlegen !"]) ?>
        <?php if( $current_user->activation_button_toggle() ): ?>
            <?= Html::a(Yii::t('app', '<span class=" glyphicon glyphicon-ok"></span>'), ['activate'], ['class' => 'btn btn-info', 'data-toggle' =>"tooltip", 'title'=> "Zugang für alle Benutzer freigeben !"]) ?>
        <?php else: ?>
            <?= Html::a(Yii::t('app', '<span class=" glyphicon glyphicon-remove"></span>'), ['deactivate'], ['class' => 'btn btn-danger', 'data-toggle' =>"tooltip", 'title'=> "Zugang für alle Benutzer sperren !"]) ?>
        <?php endif ?>
    </div>
</div>
<div class="tehnical-index-desktop">
    <div class="tehnical-index-desktop coworker-table-view">
        <?php Pjax::begin(); ?>    
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'summary' => '',
                'rowOptions' => function ($model, $key, $index, $grid) {
                    return ['class' => "grid-view-style"];
                },
                'columns' => [
                    ['label' => 'Vorname',
                       'attribute' => "first_name",
                       'value' => function ($data){ return $data->first_name; },
                    ],
                    ['label' => 'Nachname',
                       'attribute' => "last_name",
                       'value' => function ($data){ return $data->last_name; },
                    ],
                    'email',
                    'Telefonnummer',
                    [
                        'format' => 'raw',
                        'label' => 'Benutzer löschen',
                        'value' => function($model, $key, $index, $column) {
                                return Html::a(
                                    '',
                                    Url::to(['coworkers/delete', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['coworkers/delete', "id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-trash',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Benutzer löschen !",
                                    ]
                                );
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => 'Passwort zurücksetzen',
                        'value' => function($model, $key, $index, $column) {
                                return Html::a(
                                    '',
                                    Url::to(['coworkers/reset-password', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['reset-password', "id" => $model->id]),
                                        'class'=>'btn btn-warning glyphicon glyphicon-refresh btn-spinner',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Passwort des Benutzers zurücksetzen !",
                                    ]
                                );
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => 'Aktivität',
                        'value' => function($model, $key, $index, $column) {
                            if( $model->coworker_active ) {

                                return Html::a(
                                    'Sperren',
                                    Url::to(['coworkers/coworker-activation', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['reset-password', "id" => $model->id]),
                                        'class'=>'btn btn-danger btn-block',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Zugang für Benutzer sperren !",
                                    ]
                                );
                            }else {

                                return Html::a(
                                    'Freigeben',
                                    Url::to(['coworkers/coworker-activation', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['reset-password', "id" => $model->id]),
                                        'class'=>'btn btn-success btn-block',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Zugang für Benutzer freigeben !",
                                    ]
                                );                            
                            }
                        }
                    ],
                ],
            ]); ?>
        <?php Pjax::end(); ?>
        <div class="spinner-well hide">
            <?= Spinner::widget([
                'preset' => Spinner::LARGE,
                'color' => 'blue',
                'align' => 'center'
            ])?>
        </div>
    </div>
</div>
<div class="tehnical-index-mobile">
    <?php if( count($coworkers_mobile->getModels()) > 0 ): ?>
        <?php $form = ActiveForm::begin([
                'action' => ['index'],
                'method' => 'get',
            ]); ?>
            <label>Nach Benutzer suchen:</label>
            <?= $form->field($search_mobile, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
            <div class="form-group">
                <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
            </div>
        <?php ActiveForm::end(); ?>
    <?php endif ?>
    <?php Pjax::begin(); ?> 
        <?php foreach ($coworkers_mobile->getModels() as $key => $model ): ?>
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Email</td>
                        <td><?= $model->email ?></td>
                    </tr>
                    <tr>
                        <td>Vorname</td>
                        <td><?= $model->first_name ?></td>
                    </tr>
                    <tr>
                        <td>Nachname</td>
                        <td><?= $model->last_name ?></td>
                    </tr>
                    <tr>
                        <td>Telefonnummer</td>
                        <td><?= $model->Telefonnummer ?></td>
                    </tr>
                    <tr>
                        <td>Aktivität</td>
                        <td>
                            <?php if( $model->coworker_active): ?>
                                <?= Html::a('Sperren', ['coworkers/coworker-activation', "id" => $model->id], ['class' => 'btn btn-block btn-danger']) ?>
                            <?php else: ?>
                                <?= Html::a('Freigeben', ['coworkers/coworker-activation', "id" => $model->id], ['class' => 'btn btn-block btn-success']) ?>
                            <?php endif ?>        
                        </td>
                    </tr>
                    <tr>
                        <td>Passwort zurücksetzen</td>
                        <td><?= Html::a('Passwort zurücksetzen', ['coworkers/reset-password', "id" => $model->id], ['class' => 'btn btn-block btn-warning btn-spinner']) ?></td>
                    </tr>
                    <tr>
                        <td>Benutzer löschen</td>
                        <td><?= Html::a('Benutzer löschen', ['coworkers/delete', "id" => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endforeach ?>
    <?php Pjax::end(); ?>
</div>