<?php

/* @var $this \yii\web\View */
/* @var $content string */

use backend\assets\AppAsset;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use common\widgets\Alert;
use common\models\User;
use common\models\Coworker;
$url = "https://www.freieingenieure.com/";
AppAsset::register($this);
$user_id = Yii::$app->user->getId();
$coworker = Coworker::find()->where(['user_id' => $user_id])->one();
$company = $coworker->getCompany()->one();

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="SHORTCUT ICON" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="shortcut icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" type="image/x-icon" />
    <link rel="shortcut icon" href="<?php echo Yii::$app->request->baseUrl; ?>/favicon.ico" type="image/x-icon" />
    <?= Html::csrfMetaTags() ?>
    <title>anlagendoku | Aufzugsprüfer | Aufzugsprüfung | Freie Ingenieure | Aufzug | Aufzugsanlage | Aufzugsgesetz | Behindertenlift | Treppenlift | Regelmäßige Überprüfung | Aufzugstechnik | Personenaufzug</title>
    <meta name="description" content="Aufzugsprüfung Wien">
    <meta name="keywords" content="Aufzugsprüfer, Aufzugsprüfung, Freie Ingenieure, Aufzug, Aufzugsanlage, Aufzugsgesetz, Behindertenlift, Treppenlift, Regelmäßige Überprüfung, Aufzugstechnik, Personenaufzug, aufzugsprüfer, aufzugsprüfung, freie ingenieure, aufzug, aufzugsanlage, aufzugsgesetz, behindertenlift, treppenlift, regelmäßige Überprüfung, aufzugstechnik, personenaufzug">  
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    NavBar::begin([
        'brandLabel' => Html::img(Yii::$app->request->baseUrl.'/images/FI_logo.jpg', ['alt'=>Yii::$app->name, 'class' => 'img-responsive img-freie']),
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    if ( $user_id && $coworker && $company )
    { 
        $menuItems = [
            ['label' => 'Anlagen', 'url' => ['/company/anlagen/index']],
            ['label' => 'Profile', 'url' => ['/company/coworker-profile/index']],
        ];
    }
    if (Yii::$app->user->isGuest) {
        $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
    } else {
        $menuItems[] = '<li>'
            . Html::beginForm(['/site/logout'], 'post')
            . Html::submitButton(
                'Logout (' . Yii::$app->user->identity->username . ')',
                ['class' => 'btn btn-link logout']
            )
            . Html::endForm()
            . '</li>';
    }
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $menuItems,
    ]);
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="text-center">Copyright © 2017 FI – Technisches Büro für Aufzugstechnik e.U. <?= Html::a('www.freieingenieure.com', $url, ['target'=>'_blank']); ?></p>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>