<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
$s3_path = S3_PATH;

/* @var $this yii\web\View */
/* @var $model common\models\User */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(['options' => ['class' => 'admin-form', 'enctype' => 'multipart/form-data']]); ?>
    
        <?= $form->field($model, 'email')->textInput(['maxlength' => true])->label("Email") ?>
        <?= $form->field($model, 'first_name')->textInput(['maxlength' => true])->label("Vorname") ?>
        <?= $form->field($model, 'last_name')->textInput(['maxlength' => true])->label("Nachname") ?>
        <?= $form->field($model, 'Telefonnummer')->textInput(['maxlength' => true])->label("Telefonnummer") ?>

        <?= $form->field($model, 'image')->widget(FileInput::classname(), ['options' => ['accept' => 'image/*', 'class' => 'select-image'],
            'pluginOptions'=>[
                'allowedFileExtensions'=>['jpg', 'png'],
                'showUpload' => false,
                'showRemove' => false,
                'initialPreview' => [
                    $model->image ? Html::img($s3_path. 'profile/'.$model->image) : false, // checks the models to display the preview
                ],
                'overwriteInitial' => true,
            ],
        ]) ?>
        <div class="form-group">
            <?= Html::a(Yii::t('app', 'Change Password'), ['password', 'id' => $model->id], ['class' => 'btn btn btn-warning']) ?>
        </div>  
        <div class="btn-profile-postion">
            <div class="form-group btn-profile-save">
                <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Speichern') : Yii::t('app', 'Speichern'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
            </div>
            <div class="form-group btn-profile-cancel">
                <?= Html::a(Yii::t('app', 'Cancel'), ['index'], ['class' => 'btn btn btn-warning']) ?>
            </div> 
        </div>
    <?php ActiveForm::end(); ?>
</div>