
<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
$s3_path = S3_PATH;
?>
<div class="container-tehnic">
        <h3>Stammdaten</h3>
    <table class="table table-striped table-size-decoration">
        <tbody>
            <?php if( $model->ObjektNr ): ?>
                <tr>
                    <th>Objekt Nr</th>
                    <td><?= $model->ObjektNr ?></td>
                </tr>                    
            <?php endif ?>
            <tr>                
                <th>Anlagen Nr</th>
                <td>AT<?= $model->id ?></td>
            </tr>
            <tr>
                <th>Fabriks Nr</th>
                <td><?= $model->FabriksNr ?></td>
            </tr>
            <tr>
                <th>Betreiber</th>
                <td><?= $model->getUser()->one()->Betreiber ?></td>
            </tr>
            <?php if( $model->WiederkehrendeUberprufungExist() ): ?>
                <tr>
                    <th>Letzte wiederkehrende Prüfung</th>
                    <td><?= $model->getLastActualPrufungen()->Prufungsdatum ?></td>
                </tr>
                <tr>
                    <th>Mängel</th>
                    <?php if ( $model->getLastActualPrufungen()->Mangel != "" || $model->getLastActualPrufungen()->Mangel !== null ): ?>
                        <td><?= $model->getLastActualPrufungen()->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                    <?php else: ?>
                        <td></td>
                    <?php endif ?>
                </tr>
                <tr>
                    <th>Download PDF</th>
                    <?php if ( $model->getLastActualPrufungen()->url != null || $model->getLastActualPrufungen()->url != ""  ): ?>
                        <td>
                            <?php $link= $s3_path."pdf/". $model->getLastActualPrufungen()->url ?>
                            <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                        </td>
                    <?php else: ?>
                        <td></td>
                    <?php endif ?>
                </tr>
            <?php endif ?>
        </tbody>
    </table>
    <h3>Standort</h3>
    <table class="table table-striped table-size-decoration">
        <tbody>
            <tr>
                <th>Strasse</th>
                <td><?= $model->AdresseStreat ?></td>
            </tr>
            <tr>
                <th>Zusatz</th>
                <td><?= $model->Zusatz ?></td>
            </tr>
            <tr>
                <th>Ort</th>
                <td><?= $model->AdresseOrt ?></td>
            </tr>
            <tr>
                <th>PLZ</th>
                <td><?= $model->AdressePLZ ?></td>
            </tr>
        </tbody>
    </table>
    <h3>Technische Daten</h3>
    <table class="table table-striped table-size-decoration">
        <tbody>
            <tr>
                <th>Type</th>
                <td><?= $model->Type ?></td>
            </tr>
            <?php if ( $model->type2 ): ?>
                <tr>
                    <th>Type 2</th>
                    <td><?= $model->type2 ?></td>
                </tr>
            <?php endif ?>
            <tr>
                <th>Baujahr</th>
                <td><?= $model->Baujahr ?></td>
            </tr>
            <tr>
                <th>Hersteller</th>
                <td><?= $model->Hersteller ?></td>
            </tr>
            <tr>
                <th>Durchfahrtslichte in m</th>
                <td><?= $model->Durchfahrtslichte_in_m ?></td>
            </tr>
            <tr>
                <th>Prüfgrundlage</th>
                <td><?= $model->Prufgrundlage ?></td>
            </tr>
            <tr>
                <th>Antriebsart</th>
                <td><?= $model->Antriebsart ?></td>
            </tr>
            <tr>
                <th>Prüfintervall</th>
                <td><?= $model->Profintervall ?> Monate</td>
            </tr>
        </tbody>
    </table>
    <div class="tehnical-view">
        <h3>Dokumente</h3>
        <table class="table table-striped table-size-decoration">
            <thead class="table-size-decoration-head">
                <tr>
                    <th>Datum</th>
                    <th>Prüfungsdatum</th>
                    <th>Art</th>
                    <th>Mängel</th>
                    <th>in Vollwart. enth.</th>
                    <th>Kostenschätzung</th>
                    <th>PDF</th>
                    <th>Fotos</th>
                </tr>
            </thead>
            <tbody class="table-size-decoration-body">
                <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
                    <?php if( $application->url || count( $application->getImages()->all()) > 0 ): ?>
                        <tr>
                            <td><?= $application->formatDatum(); ?></td>
                            <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                                <td><?= $application->formatPrufungsdatum(); ?></td>  
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>   
                            <td><?= $application->Art; ?></td>
                            <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                                <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                            <td class="VollwartungEnthalten-desktop-width"><?= $application->VollwartungEnthalten; ?></td>
                            <td><?= $application->Kostenschatzung; ?></td>
                            <?php if ( $application->url != null || $application->url != ""  ): ?>
                                <td>
                                    <?php $link= $s3_path."pdf/". $application->url ?>
                                    <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                                </td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?> 
                            <td>
                                <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                    <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'profile-link']) ?>
                                    <div class="desktop-short-description">
                                        <?= $application->short_photo_description ?>
                                    </div>
                                <?php endif ?>
                            </td>
                            <td></td>
                        </tr>
                    <?php endif ?>
                <?php endforeach ?>  
            </tbody>
        </table>
    </div>
</div>

<div class="container-tehnic-mobile">
        <h4>Stammdaten</h4>
    <table class="table table-striped table-bordered table-mobile table-size-decoration">
        <tbody>
            <?php if( $model->ObjektNr ): ?>
                <tr>
                    <th>Objekt Nr</th>
                    <td><?= $model->ObjektNr ?></td>
                </tr>                    
            <?php endif ?>
            <tr>                
                <th>Anlagen Nr</th>
                <td>AT<?= $model->id ?></td>
            </tr>
            <tr>
                <th>Fabriks Nr</th>
                <td><?= $model->FabriksNr ?></td>
            </tr>
            <tr>
                <th>Betreiber</th>
                <td><?= $model->getUser()->one()->Betreiber ?></td>
            </tr>
            <?php if( $model->WiederkehrendeUberprufungExist() ): ?>
                <tr>
                    <th>Letzte wiederkehrende Prüfung</th>
                    <td><?= $model->getLastActualPrufungen()->Prufungsdatum ?></td>
                </tr>
                <tr>
                    <th>Mängel</th>
                    <?php if ( $model->getLastActualPrufungen()->Mangel != "" || $model->getLastActualPrufungen()->Mangel !== null ): ?>
                        <td><?= $model->getLastActualPrufungen()->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                    <?php else: ?>
                        <td></td>
                    <?php endif ?>
                </tr>
                <tr>
                    <th>Download PDF</th>
                    <?php if ( $model->getLastActualPrufungen()->url != null || $model->getLastActualPrufungen()->url != ""  ): ?>
                        <td>
                            <?php $link= $s3_path."pdf/". $model->getLastActualPrufungen()->url ?>
                            <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                        </td>
                    <?php else: ?>
                        <td></td>
                    <?php endif ?>
                </tr>
            <?php endif ?>
        </tbody>
    </table>
    <h4>Standort</h4>
    <table class="table table-striped table-bordered table-mobile table-size-decoration">
        <tbody>
            <tr>
                <th>Strasse</th>
                <td><?= $model->AdresseStreat ?></td>
            </tr>
            <tr>
                <th>Zusatz</th>
                <td><?= $model->Zusatz ?></td>
            </tr>
            <tr>
                <th>Ort</th>
                <td><?= $model->AdresseOrt ?></td>
            </tr>
            <tr>
                <th>PLZ</th>
                <td><?= $model->AdressePLZ ?></td>
            </tr>
        </tbody>
    </table>
    <h4>Technische Daten</h4>
    <table class="table table-striped table-bordered table-mobile table-size-decoration">
        <tbody>
            <tr>
                <th>Type</th>
                <td><?= $model->Type ?></td>
            </tr>
            <?php if ( $model->type2 ): ?>
                <tr>
                    <th>Type 2</th>
                    <td><?= $model->type2 ?></td>
                </tr>
            <?php endif ?>
            <tr>
                <th>Baujahr</th>
                <td><?= $model->Baujahr ?></td>
            </tr>
            <tr>
                <th>Hersteller</th>
                <td><?= $model->Hersteller ?></td>
            </tr>
            <tr>
                <th>Durchfahrtslichte in m</th>
                <td><?= $model->Durchfahrtslichte_in_m ?></td>
            </tr>
            <tr>
                <th>Prüfgrundlage</th>
                <td><?= $model->Prufgrundlage ?></td>
            </tr>
            <tr>
                <th>Antriebsart</th>
                <td><?= $model->Antriebsart ?></td>
            </tr>
            <tr>
                <th>Prüfintervall</th>
                <td><?= $model->Profintervall ?> Monate</td>
            </tr>
        </tbody>
    </table>
    <h4>Dokumente</h4>
    <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
        <?php if( $application->url || count( $application->getImages()->all()) > 0 ): ?>
            <table class="table table-striped table-bordered table-mobile table-size-decoration">
                <tbody>
                    <tr>
                        <td>Datum</td>
                        <td><?= $application->formatDatum(); ?></td>
                    </tr>
                    <tr>
                        <td>Prüfungsdatum</td>
                        <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                            <td><?= $application->formatPrufungsdatum(); ?></td>  
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                    </tr>
                    <tr>
                        <td>Art</td>
                        <td><?= $application->Art; ?></td>
                    </tr>
                    <tr>
                        <td>Mängel</td>
                        <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                            <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                    </tr>
                    <tr>
                        <td>in Vollwart. enth.</td>
                        <td><?= $application->VollwartungEnthalten; ?></td>
                    </tr>
                    <tr>
                        <td>Kostenschätzung</td>
                        <td><?= $application->Kostenschatzung; ?></td>
                    </tr>
                    <tr>
                        <td>PDF</td>
                        <?php if ( $application->url != null || $application->url != ""  ): ?>
                            <td>
                                <?php $link= $s3_path."pdf/". $application->url ?>
                                <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                            </td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                    </tr>
                    <tr>
                        <td>Fotos</td>
                        <td>
                            <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                <div>
                                    <?= $application->short_photo_description ?>
                                </div>
                                <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'profile-link']) ?>
                            <?php endif ?>
                        </td>
                    </tr> 
                </tbody>
            </table>
        <?php endif ?>
    <?php endforeach ?> 
</div>