<?php

namespace frontend\modules\company\controllers;

use Yii;
use common\models\UserInvitation;
use common\models\User;
use common\models\Coworker;
use common\models\search\AnlagenFrontendSearch;
use common\models\search\AnlagenGlobalSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AnlagenController implements the CRUD actions for Tehnical model.
 */


class RegistrationController extends Controller
{

    /**
     * @inheritdoc
     */
    public function behaviors()
    {

        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }


    public function beforeAction($action)
    {
       if(Yii::$app->user->isGuest){

            $this->ensure_redirect();
       }else {
            $this->ensure_redirect();
       }
      return true;
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */
    public function actionIndex()
    {

        $user_id = $_GET['user_id'];
        $email = $_GET['email'];
        $token = $_GET['token'];
        $userInvitation = UserInvitation::find()->where(['email' => $email, 'user_id' => $user_id])->orderBy('id DESC')->one();

        $model = User::findOne($user_id);
        $model->setScenario('coworker');

        if ($model->load(Yii::$app->request->post()) ) {

            $model->setPassword($model->new_password);
            $model->client_password = $model->new_password;
            $model->send_mail = "0";
            $model->save();

            $userInvitation->accept = true;
            $userInvitation->save();

            Yii::$app->user->login($model);
            return $this->redirect(['/company/anlagen/index']);
        }

        return $this->render('index', [
            'model' => $model,
        ]);
    }

    protected function ensure_redirect()
    {
        $user_id = $_GET['user_id'];
        $email = $_GET['email'];
        $token = $_GET['token'];
        $acepted_user_invitation = UserInvitation::find()->where(['email' => $email, 'user_id' => $user_id, 'accept' => true])->orderBy('id DESC')->one();
        
        if ( $acepted_user_invitation ) {

            $model = User::findOne($user_id);
            Yii::$app->user->logout();
            Yii::$app->user->login($model);
            return $this->redirect(['/company/anlagen/index']);            
        }else {
            Yii::$app->user->logout();
        }
    }
}