<?php

namespace frontend\modules\company\controllers;

use Yii;
use common\models\Tehnical;
use common\models\User;
use common\models\Coworker;
use common\models\search\AnlagenFrontendSearch;
use common\models\search\AnlagenGlobalSearch;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use yii\db\Expression;

/**
 * AnlagenController implements the CRUD actions for Tehnical model.
 */
class CoworkerProfileController extends BaseController
{

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $this->ensureRedirectToCurrenntRoute();
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tehnical models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = $this->currentUser();

        return $this->render('index', [
            'model' => $dataProvider,
        ]);
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {

        $user_id = Yii::$app->user->getId();
        $url_id = $_GET['id'];

        if ( $url_id != $user_id ) {

            return $this->redirect(['index']);
        }

        $model = $this->findModel($id);
        $model->setScenario('requiredNameCoworker');
        $model->active = 1;
        $s3_env = S3_ENV;
        $old_picture = $model->OldAttributes['image'];

        if(isset($_POST['change-password']) && $model->load(Yii::$app->request->post()) && $model->save() ) {
            $model->username = $model->email;
            $image = UploadedFile::getInstance($model, 'image');
            $random_string = bin2hex(openssl_random_pseudo_bytes(5));
            if ( $image != null || $image != "" ) {
                $imageformat = $image->baseName. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension;
            }else {
                $imageformat = $old_picture;
            }
            $model->image = $imageformat;
            if($model->save()) {
                Yii::$app->session->setFlash('success', 'You have successfully updated profile!');                
            }
            if ( $image ) {
                $image->saveAs('uploads/'.$model->image);
                Yii::$app->get('s3bucket')->upload($s3_env. 'profile/'.$model->image, 'uploads/'.$model->image);
                gc_collect_cycles();
                unlink('uploads/'.$model->image); 
                $this->deleteFromS3($old_picture, $s3_env);
            }
            return $this->redirect(['password', 'id' => $model->id]);

         }else if($model->load(Yii::$app->request->post()) ) {

            $model->username = $model->email;
            $image = UploadedFile::getInstance($model, 'image');
            $random_string = bin2hex(openssl_random_pseudo_bytes(5));
            $imageformat = $image ? $image->baseName. bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension : $old_picture;
            $model->image = $imageformat;

            if($model->save()) {
                Yii::$app->session->setFlash('success', 'You have successfully updated profile!');                
            }
            if ( $image ) {

                $image->saveAs('uploads/'.$model->image);
                Yii::$app->get('s3bucket')->upload($s3_env. 'profile/'.$model->image, 'uploads/'.$model->image);
                gc_collect_cycles();
                unlink('uploads/'.$model->image); 
             #   $this->deleteFromS3($old_picture, $s3_env);
            }
            return $this->redirect(['index']);

        } else {

            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionPassword($id)
    {
        $model = $this->findModel($id);
        $model->setScenario('changePwd');
        $model->active = 1;

        if ($model->load(Yii::$app->request->post()) && Yii::$app->security->validatePassword($model->old_password, $model->password_hash) ) {
            $model->setPassword($model->new_password);
            $model->client_password = $model->new_password;
            $model->save();
            return $this->redirect(['index']);

        } else {
            $model->old_password ? $model->addError('old_password', 'Incorrect old password.') : "";
            return $this->render('password', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }
    

    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
