<?php

namespace frontend\modules\company\controllers;

use Yii;
use common\models\Role;
use common\models\User;
use common\models\Tehnical;
use common\models\Coworker;
use common\models\search\TehinicalFrontendSearch;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * AnlagenController implements the CRUD actions for Tehnical model.
 */
abstract class BaseController extends Controller
{

    public function beforeAction($action)
    {
        if ($this->logUser() == false) {

            if ( $_SERVER['HTTP_HOST'] == "www.anlagendoku.com" ) {

                header("Location: https://www.anlagendoku.com/site/login");
            }else if ( $_SERVER['HTTP_HOST'] == "stage.anlagendoku.com" ) {

                header("Location: https://stage.anlagendoku.com/site/login");
            }else if ( $_SERVER['HTTP_HOST'] == "dev.anlagendoku.com" ) {

                header("Location: https://dev.anlagendoku.com/site/login");
            }else {

                header("Location: http://localhost/Aufzugstechnik/frontend/web/site/login");   
            }
            die();
        }

        $this->layout = '@frontend/modules/company/views/layouts/main.php';
        return parent::beforeAction($action);
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    protected function currentUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : $this->redirect(['site/index']);
    }

    protected function logUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : false;
    }

    protected function isAdmin()
    {
        $id = Yii::$app->user->getId();
        return $id ? true : false;
    }


    protected function ensureRedirectToCurrenntRoute()
    {
        $current_user = $this->currentUser();
        
        if($current_user && $current_user->role_id == "3" && $current_user->coworker_active == false) {
            $this->redirect(['/site/index']);
        }
    }

    protected function findCompany()
    {
        $current_user = User::currentUser();
        $coworker = Coworker::find()->where(['user_id' => $current_user->id])->one();

        return $company = $coworker->getCompany()->one();
    }
}
