<?php

namespace frontend\modules\company\controllers;

use Yii;
use common\models\Tehnical;
use common\models\User;
use common\models\Coworker;
use common\models\search\AnlagenFrontendSearch;
use common\models\search\AnlagenGlobalSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * AnlagenController implements the CRUD actions for Tehnical model.
 */
class AnlagenController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $this->ensureRedirectToCurrenntRoute();
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tehnical models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AnlagenFrontendSearch();
        $searchModelGlobal = new AnlagenGlobalSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $company = $this->findCompany();

        if ( $company && $company->getTehnicals()) {

            $tehnics_all = $company->getTehnicals();

        }else {

            $tehnics_all = null;
        }   

        $tehnics = $searchModelGlobal->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'tehnics' => $tehnics,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnics_all' => $tehnics_all,
        ]);
    }

    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $company = $this->findCompany();
        $model = $company->getTehnicals()->where(['id' => $id])->one();

        if ( $model ) {

            return $this->render('view', [
                'model' => $model,
            ]);
        }else {

            $this->redirect(['anlagen/index']);
        }
    }
    

    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tehnical::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }


    public function display_pagination_unlesss_SearchQueryParams()
    {   

        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['AnlagenGlobalSearch']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }
}