<?php
namespace frontend\models;

use yii\base\Model;
use common\models\User;

/**
 * Signup form
 */
class CreateCoworker extends Model
{
    public $email;
    public $user;
    public $role_id;
    public $company_id;
    public $password;
    public $Betreiber;
    public $AdresseBundesland;
    public $AdresseOrt;
    public $AdresseStreat;
    public $AdressePLZ;
    public $AdresseStiege;
    public $Telefonnummer;
    public $send_mail;
    public $send_message_from_mail;
    public $send_standard_content_with_email;
    public $subject;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
          //  ['role_id', 'required'],
            ['user','safe'],
            [['company_id','Betreiber', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Telefonnummer', 'send_mail', 'send_message_from_mail', 'send_standard_content_with_email', 'subject', 'username'], 'safe'],
            ['email', 'trim'],
            ['email', 'required', 'message' => 'Bitte geben Sie eine gültige E-Mail-Adresse an.'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['email', 'unique', 'targetClass' => '\common\models\User', 'message' => 'Die angegebene E-Mail-Adresse ist bereits vergeben.'],
           /* ['password', 'required'],
            ['password', 'string', 'min' => 6],*/
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    public function create_coworker($user_password, $current_user)
    {
        if (!$this->validate()) {
            return null;
        }
        $user = new User();
        $user->username = $this->email;
        $user->email = $this->email;
        $user->role_id = 3;
        $user->setPassword($user_password);
        $user->client_password = $user_password;
        $user->Betreiber = $current_user->Betreiber;
        $user->generateAuthKey();
        $user->coworker_active = true;
        return $user->save() ? $user : null;
    }
}