<?php

namespace frontend\controllers;

use Yii;
use common\models\Tehnical;
use common\models\User;
use common\models\search\TehinicalFrontendSearch;
use common\models\search\TehinicalGlobalSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\GoogleCordinate;
use yii\web\Response;
use yii\helpers\ArrayHelper;
use dosamigos\google\maps\services\DirectionsClient;
use dosamigos\google\maps\LatLng;
use dosamigos\google\maps\services\DirectionsWayPoint;
use dosamigos\google\maps\services\TravelMode;
use dosamigos\google\maps\overlays\PolylineOptions;
use dosamigos\google\maps\services\DirectionsRenderer;
use dosamigos\google\maps\services\DirectionsService;
use dosamigos\google\maps\overlays\InfoWindow;
use dosamigos\google\maps\overlays\Marker;
use dosamigos\google\maps\Map;
use dosamigos\google\maps\services\DirectionsRequest;
use dosamigos\google\maps\overlays\Polygon;
use dosamigos\google\maps\layers\BicyclingLayer;
use yii\data\Pagination;

/**
 * TehnicController implements the CRUD actions for Tehnical model.
 */
class TehnicController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $this->ensureRedirectToCurrenntRoute();

        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tehnical models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new TehinicalFrontendSearch();
        $searchModelGlobal = new TehinicalGlobalSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $current_user = User::currentUser();

        if ( $current_user && $current_user->getTehnicals()) {
            $tehnics_all = Tehnical::find()->where(['user_id' => $current_user->id])->andWhere(['active' => 1]);
        }else {

            $tehnics_all = null;
        }        

        $tehnics = $searchModelGlobal->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'tehnics' => $tehnics,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnics_all' => $tehnics_all,
        ]);
    }

    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   

        $model = User::currentUser()->getTehnicals()->where(['id' => $id])->one();


        if ( $model ) {

            return $this->render('view', [
                'model' => $model,
            ]);
        }else {

            $this->redirect(['tehnic/index']);
        }
        #   $show_google_map = $this->renderGoogleMap($model);
    }

    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tehnical::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }


    protected function renderGoogleMap($model)
    {

        $start_destination = new LatLng(['lat' => $model->lat, 'lng' => $model->lng]);
        $anlagen = new LatLng(['lat' => $model->lat, 'lng' => $model->lng]);
        $coord = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);

        $map = new Map([
            'center' => $start_destination,
            'zoom' => 50,
            'width' => '100%',
        ]);

        $directionsRequest = new DirectionsRequest([

            'origin' => $start_destination,
            'destination' => $anlagen,
            'travelMode' => TravelMode::DRIVING
        ]);

        // Lets configure the polyline that renders the direction
        $polylineOptions = new PolylineOptions([
            'strokeColor' => '#FFAA00',
            'draggable' => true
        ]);

        // Now the renderer
        $directionsRenderer = new DirectionsRenderer([
            'map' => $map->getName(),
            'polylineOptions' => $polylineOptions
        ]);

        // Finally the directions service
        $directionsService = new DirectionsService([
            'directionsRenderer' => $directionsRenderer,
            'directionsRequest' => $directionsRequest
        ]);

        // Thats it, append the resulting script to the map
        $map->appendScript($directionsService->getJs());
        
        return $map->display();      
    }

    public function display_pagination_unlesss_SearchQueryParams()
    {   

        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['TehinicalGlobalSearch']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }
}
