<?php

namespace frontend\controllers;

use Yii;
use common\models\TehnicReview;
use common\models\User;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * TehnicController implements the CRUD actions for Tehnical model.
 */
class FotosController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $this->ensureRedirectToCurrenntRoute();

        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }



    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $tehnic_review = $this->findModel($id);
        $tehnical = $tehnic_review->getTehnic()->one();
        $anlagen = $this->currentUser()->getTehnicals()->where(['id' => $tehnical->id])->one();

        if ( $anlagen ) {

            return $this->render('view', [
                'model' => $tehnic_review,
                'anlagen' => $tehnical,
            ]);
        }else {

            $this->redirect(['site/index']);
        }
    }

    

    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = TehnicReview::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
