<?php

namespace frontend\controllers;

use Yii;
use frontend\models\CreateCoworker;
use common\models\User;
use common\models\Coworker;
use common\models\UserInvitation;
use common\models\Tehnical;
use common\models\search\CoworkerFrontendSearch;
use common\models\search\CoworkerFrontendGlobalSearch;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use yii\db\Expression;
use yii\data\Pagination;
use yii\helpers\ArrayHelper;
/**
 * ProfileController implements the CRUD actions for User model.
 */
class CoworkersController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {

        $this->ensureRedirectToCurrenntRoute();

        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {

        $searchModel = new CoworkerFrontendSearch();
        $current_user = $this->currentUser();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $search_mobile = new CoworkerFrontendGlobalSearch();

        $coworkers = Coworker::find()->where(['company_id' => $current_user->id])->all();
        $covorkers_ids = ArrayHelper::map($coworkers,'id', 'user_id');

        $coworkers_mobile = $search_mobile->search(Yii::$app->request->queryParams);
        $coworkers_mobile->query->andWhere(['in', 'id', $covorkers_ids]);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'current_user' => $current_user,
            'search_mobile' => $search_mobile,
            'coworkers_mobile' => $coworkers_mobile,
        ]);
    }

    public function actionNew()
    {
        $model = new CreateCoworker();
        $current_user = $this->currentUser();

        if($model->load(Yii::$app->request->post()))
        {

            $user_password = bin2hex(openssl_random_pseudo_bytes(10));
            $user = $model->create_coworker($user_password, $current_user);

            if (isset($user)) {

                $this->create_coworker_after_create_user($user, $current_user);
                $invitation = $this->ensure_user_invitation($user);

                if ( $invitation ) {

                    $this->sendMailToCoworker($invitation, $current_user, $user);
                }
                
                Yii::$app->session->setFlash('success', 'Der Benutzer wurde erfolgreich angelegt. Der Benutzer erhält in Kürze eine Email mit den Zugangsdaten.');
                return $this->redirect('index');
            }
        }
        return $this->render('new', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
#    public function actionUpdate($id)
#    {
#        $model = $this->findModel($id);
#        $model->setScenario('changePswAdmin');
#        $model->setScenario('coworker');
#        if ($model->load(Yii::$app->request->post()) ) {
#
#            $model->setPassword($model->new_password);
#            $model->client_password = $model->new_password;
#            $model->send_mail = "0";
#            $model->username = $model->email;
#            $model->save();
#
#            return $this->redirect(['index']);
#
#        } else {
#            $model->old_password ? $model->addError('old_password', 'Incorrect old password.') : "";
#            return $this->render('update', [
#                'model' => $model,
#            ]);
#        }
#    }


    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {

        $this->findModel($id)->delete();

        return $this->redirect(['/coworkers/index']);
    }

    public function actionResetPassword($id)
    {
        $current_user = $this->currentUser();
        $password = bin2hex(openssl_random_pseudo_bytes(10));
        $coworker = $this->findModel($id);
        $coworker->setPassword($password);
        $coworker->client_password = $password;

        if ( $coworker->save() ) {

            $invitation = $this->ensure_reset_user_invitation_to_false($coworker);

            if ( $invitation ) {
                
                $this->sendMailToCoworkerResetPassword($invitation, $current_user, $coworker);
            }

            Yii::$app->session->setFlash('success', 'Passwort wurde erfolgreich zurückgesetzt. Der Benutzer erhält in Kürze eine Email mit der Möglichkeit ein neues Passwort zu konfigurieren.');
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'Something wrong !');
        }
    }

    public function actionDeactivate()
    {
        $this->activation_toggle(false);

        return $this->redirect(['index']);
    }

    public function actionActivate()
    {
        $this->activation_toggle(true);

        return $this->redirect(['index']);
    }


    public function actionCoworkerActivation($id)
    {
        $coworker = $this->findModel($id);

        if ( $coworker->coworker_active ) {

            $coworker->coworker_active = false;
        }else {
            $coworker->coworker_active = true;
        }
        $coworker->save();
        return $this->redirect(['index']);
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    protected function create_coworker_after_create_user($user, $current_user)
    {
        $coworker = new Coworker();
        $coworker->user_id = $user->id;
        $coworker->company_id = $current_user->id;
        $coworker->save();
    }

    protected function ensure_user_invitation($user)
    {
        $invitation = new UserInvitation();
        $invitation->email = $user->email;
        $invitation->user_id = $user->id;
        $invitation->token =  bin2hex(openssl_random_pseudo_bytes(20));
        if ( $invitation->save()) {

            return $invitation;
        }
    }

    protected function activation_toggle($status)
    {
        $current_user = $this->currentUser();
        $coworkers = Coworker::find()->where(['company_id' => $current_user->id])->all();
        $covorkers_ids = ArrayHelper::map($coworkers,'id', 'user_id');
    
        User::updateAll(['coworker_active' => $status], ['AND', 'role_id = 3', ['in', 'id', $covorkers_ids]]);

        $current_user->coworker_active = $status;
        $current_user->save();        
    }

    protected function ensure_reset_user_invitation_to_false($coworker) {

        $userInvitation = UserInvitation::find()->where(['user_id' => $coworker->id])->one();
        $userInvitation->accept = 0;
        $userInvitation->save();
        return $userInvitation;
    }

    protected function sendMailToCoworker($invitation, $company_user, $coworker)
    {
        Yii::$app->mailer->compose('contact', ['coworker' => $coworker, 'invitation' => $invitation, 'company_user' => $company_user])
        ->setFrom('office@anlagendoku.com')
        ->setTo($coworker->email)
        ->setSubject("Ihre Zugangsdaten zu anlagendoku.com")
        ->send(); 
    }


    protected function sendMailToCoworkerResetPassword($invitation, $company_user, $coworker)
    {
        Yii::$app->mailer->compose('reset_password', ['coworker' => $coworker, 'invitation' => $invitation, 'company_user' => $company_user])
        ->setFrom('office@anlagendoku.com')
        ->setTo($coworker->email)
        ->setSubject("Ihr Passwort für anlagendoku.com wurde zurückgesetzt")
        ->send(); 
    }
}
