<?php

namespace frontend\controllers;

use Yii;
use common\models\Role;
use common\models\User;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * AdminController implements the CRUD actions for User model.
 */
class BaseController extends Controller
{
    public function beforeAction($action)
    {
        if ($this->logUser() == false &&  substr( Yii::$app->request->url, -strlen( 'site/login' ) ) != 'site/login') {
            header("Location: http://aufzugsbuch.at/site/login");
            die();
        }

        return true;
    }

    protected function currentUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : $this->redirect(['site/index']);
    }

    protected function logUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : false;
    }

    protected function isAdmin()
    {
        $id = Yii::$app->user->getId();
        return $id ? true : false;
    }

    protected function ensureRedirectToCurrenntRoute()
    {
        $current_user = $this->currentUser();
        
        if($current_user && $current_user->role_id == "1") {
            $this->redirect(['site/index']);
        } else if($current_user && $current_user->role_id == "3" && $current_user->coworker_active == true ) {
            $this->redirect(['company/anlagen']);
        } else if($current_user && $current_user->role_id == "3" && $current_user->coworker_active == false ) {
            $this->redirect(['site/index']);
        }
    }
}