<?php
$params = array_merge(
    require(__DIR__ . '/../../common/config/params.php'),
    require(__DIR__ . '/../../common/config/params-local.php'),
    require(__DIR__ . '/params.php'),
    require(__DIR__ . '/params-local.php')
);

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'frontend\controllers',
    'defaultRoute' => 'tehnic/index',
    'modules' => [
        'gridview' =>  [
            'class' => '\kartik\grid\Module',
        ],
        'company' => [
                'class' => 'frontend\modules\company\Company',
        ],
    ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-frontend',
            
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the frontend
            'name' => 'advanced-frontend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            /*'rules' => [
                Yii::t('app','application/index') => Yii::t('app','company/index'),
            ],*/
        ],
        'urlManagerBackEnd' => [
        'class' => 'yii\web\urlManager',
        'baseUrl' => '/backend/web',
        'enablePrettyUrl' => true,
        'showScriptName' => false,
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@frontend/mailer',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'email-smtp.eu-west-1.amazonaws.com',
                'username' => 'AKIAJ7OBAFQFZAUVY7YA',
                'password' => 'Ahdr1ODuhshRcoHXFMJD3bPBsiJIlHZPOJmiwNbWH5qd',
                'port' => '587',
                'encryption' => 'tls',
            ],
        ],
        'assetManager'=>[
            'converter'=>[
                'class'=> 'nizsheanez\assetConverter\Converter',
                'force'=> true, // true : If you want convert your sass each time without time dependency
                'destinationDir' => '', //at which folder of @webroot put compiled files
                'parsers' => [
                    'scss' => [ // file extension to parse
                        'class' => 'nizsheanez\assetConverter\Scss',
                        'output' => 'css', // parsed output file type
                        'options' => [ // optional options
                            'enableCompass' => true, // default is true
                            'importPaths' => ['/sass','/sass/_offers'], // import paths, you may use path alias here,
                            // e.g., `['@path/to/dir', '@path/to/dir1', ...]`
                            'lineComments' => true, // if true — compiler will place line numbers in your compiled output
                            'outputStyle' => 'expanded', // May be `compressed`, `crunched`, `expanded` or `nested`,
                            // see more at http://sass-lang.com/documentation/file.SASS_REFERENCE.html#output_style
                        ],
                    ],
                ]
            ]
        ],
        'urlManagerBackend' => [
            'class' => 'yii\web\urlManager',
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'baseUrl' => 'https://www.anlagendoku.com',
        ],     
    ],
    'params' => $params,
];
