<?php

use yii\db\Migration;

/**
 * Handles the creation of table `user_anlagen_coworker_control`.
 */
class m201205_132646_create_user_anlagen_coworker_control_table extends Migration
{
    
    public function up()
    {
        $this->createTable('user_anlagen_coworker_control', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'anlagen_id' => $this->integer()->notNull(),
            'control_id' => $this->integer(),
            'allowAnotherUserAccessAnlagen' => $this->integer(),
        ]);

        // creates index for column `user_id`
        $this->createIndex(
            'idx-user_anlagen_coworker_control-user_id',
            'user_anlagen_coworker_control',
            'user_id'
        );

        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-user_anlagen_coworker_control-user_id',
            'user_anlagen_coworker_control',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );


        // creates index for column `anlagen_id`
        $this->createIndex(
            'idx-user_anlagen_coworker_control-anlagen_id',
            'user_anlagen_coworker_control',
            'anlagen_id'
        );

        // add foreign key for table `tehnical`
        $this->addForeignKey(
            'fk-user_anlagen_coworker_control-anlagen_id',
            'user_anlagen_coworker_control',
            'anlagen_id',
            'tehnical',
            'id',
            'CASCADE'
        );


        // creates index for column `control_id`
    /*    $this->createIndex(
            'idx-user_anlagen_coworker_control-control_id',
            'user_anlagen_coworker_control',
            'control_id'
        );

        // add foreign key for table `coworker_controll`
        $this->addForeignKey(
            'fk-user_anlagen_coworker_control-control_id',
            'user_anlagen_coworker_control',
            'control_id',
            'coworker_controll',
            'id',
            'CASCADE'
        );*/
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `user`
        $this->dropForeignKey(
            'fk-user_anlagen_coworker_control-user_id',
            'user_anlagen_coworker_control'
        );

        // drops index for column `user_id`
        $this->dropIndex(
            'idx-user_anlagen_coworker_control-user_id',
            'user_anlagen_coworker_control'
        );

        // drops foreign key for table `tehnical`
        $this->dropForeignKey(
            'fk-user_anlagen_coworker_control-anlagen_id',
            'user_anlagen_coworker_control'
        );

        // drops index for column `anlagen_id`
        $this->dropIndex(
            'idx-user_anlagen_coworker_control-anlagen_id',
            'user_anlagen_coworker_control'
        );

        // drops foreign key for table `coworker_controll`
     /*   $this->dropForeignKey(
            'fk-user_anlagen_coworker_control-control_id',
            'user_anlagen_coworker_control'
        );

        // drops index for column `control_id`
        $this->dropIndex(
            'idx-user_anlagen_coworker_control-control_id',
            'user_anlagen_coworker_control'
        );*/

        $this->dropTable('user_anlagen_coworker_control');
    }
}
