<?php

use yii\db\Migration;

/**
 * Handles the creation of table `rest_api_auth`.
 * Has foreign keys to the tables:
 *
 * - `user`
 */
class m200827_104301_create_rest_api_auth_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('rest_api_auth', [
            'id' => $this->primaryKey(),
            'company_id' => $this->integer()->notNull(),
            'token' => $this->string(),
            'client_secret' => $this->string(),
            'name' => $this->string(),
            'title' => $this->string(),
        ]);

        // creates index for column `company_id`
        $this->createIndex(
            'idx-rest_api_auth-company_id',
            'rest_api_auth',
            'company_id'
        );

        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-rest_api_auth-company_id',
            'rest_api_auth',
            'company_id',
            'user',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `user`
        $this->dropForeignKey(
            'fk-rest_api_auth-company_id',
            'rest_api_auth'
        );

        // drops index for column `company_id`
        $this->dropIndex(
            'idx-rest_api_auth-company_id',
            'rest_api_auth'
        );

        $this->dropTable('rest_api_auth');
    }
}
