<?php

use yii\db\Migration;

/**
 * Handles the creation of table `magel`.
 * Has foreign keys to the tables:
 *
 * - `tehnic_review`
 */
class m200711_135228_create_magel_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('magel', [
            'id' => $this->primaryKey(),
            'tehnic_review_id_integer' => $this->integer()->notNull(),

            'mangel' => $this->string(),
            'frist' => $this->string(),
            'photo' => $this->text(),
        ]);

        // creates index for column `tehnic_review_id_integer`
        $this->createIndex(
            'idx-magel-tehnic_review_id_integer',
            'magel',
            'tehnic_review_id_integer'
        );

        // add foreign key for table `tehnic_review`
        $this->addForeignKey(
            'fk-magel-tehnic_review_id_integer',
            'magel',
            'tehnic_review_id_integer',
            'tehnic_review',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `tehnic_review`
        $this->dropForeignKey(
            'fk-magel-tehnic_review_id_integer',
            'magel'
        );

        // drops index for column `tehnic_review_id_integer`
        $this->dropIndex(
            'idx-magel-tehnic_review_id_integer',
            'magel'
        );

        $this->dropTable('magel');
    }
}
