<?php

use yii\db\Migration;

/**
 * Handles the creation of table `document`.
 * Has foreign keys to the tables:
 *
 * - `tenical`
 */
class m200209_174241_create_document_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('tehnical_document', [
            'id' => $this->primaryKey(),
            'tehnical_id' => $this->integer()->notNull(),
            'url' => $this->string(200)->notNull()->unique(),
        ]);

        // creates index for column `tehnical_id`
        $this->createIndex(
            'idx-tehnical_document-tehnical_id',
            'tehnical_document',
            'tehnical_id'
        );

        // add foreign key for table `tenical`
        $this->addForeignKey(
            'fk-document-tehnical_id',
            'tehnical_document',
            'tehnical_id',
            'tehnical',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `tenical`
        $this->dropForeignKey(
            'fk-tehnical_document-tehnical_id',
            'document'
        );

        // drops index for column `tehnical_id`
        $this->dropIndex(
            'idx-tehnical_document-tehnical_id',
            'document'
        );

        $this->dropTable('document');
    }
}