<?php
use yii\db\Migration;
/**
 * Handles the creation of table `coworker`.
 */
class m180424_102947_create_coworker_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('coworker', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'email' => $this->string(),
            'company_id' => $this->integer()->notNull(),
        ]);
        // creates index for column `user_id`
        $this->createIndex(
            'idx-coworker-user_id',
            'coworker',
            'user_id'
        );
        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-coworker-user_id',
            'coworker',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );
    }
    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('coworker');
    }
}