<?php
use yii\db\Migration;
/**
 * Handles the creation of table `user_invitation`.
 */
class m180424_094512_create_user_invitation_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('user_invitation', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'email' => $this->string(),
            'token' => $this->string(),
            'accept' => $this->integer()->defaultValue(0),
        ]);
        // creates index for column `user_id`
        $this->createIndex(
            'idx-user_invitation-user_id',
            'user_invitation',
            'user_id'
        );
        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-user_invitation-user_id',
            'user_invitation',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );
    }
    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `user`
        $this->dropForeignKey(
            'fk-user_invitation-user_id',
            'user_invitation'
        );
        // drops index for column `user_id`
        $this->dropIndex(
            'idx-user_invitation-user_id',
            'user_invitation'
        );
        
        $this->dropTable('user_invitation');
    }
}