<?php

use yii\db\Migration;

/**
 * Handles the creation of table `images`.
 * Has foreign keys to the tables:
 *
 * - `tehnic_review`
 */
class m170904_104824_create_images_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('images', [
            'id' => $this->primaryKey(),
            'review_id' => $this->integer()->notNull(),
            'name' => $this->string(),
            'description' => $this->text(),
        ]);

        // creates index for column `review_id`
        $this->createIndex(
            'idx-images-review_id',
            'images',
            'review_id'
        );

        // add foreign key for table `tehnic_review`
        $this->addForeignKey(
            'fk-images-review_id',
            'images',
            'review_id',
            'tehnic_review',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `tehnic_review`
        $this->dropForeignKey(
            'fk-images-review_id',
            'images'
        );

        // drops index for column `review_id`
        $this->dropIndex(
            'idx-images-review_id',
            'images'
        );

        $this->dropTable('images');
    }
}
