<?php

use yii\db\Migration;

/**
 * Handles the creation of table `aufzugswarter_tehnic_join`.
 */
class m170822_160415_create_aufzugswarter_tehnic_join_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('aufzugswarter_tehnic_join', [
            'tehnic_id' => $this->integer()->notNull(),
            'aufzugswarter_id' => $this->integer()->notNull(),
        ]);

        // creates index for column `tehnic_id`
        $this->createIndex(
            'idx-aufzugswarter_tehnic_join-tehnic_id',
            'aufzugswarter_tehnic_join',
            'tehnic_id'
        );

        // add foreign key for table `tehnical`
        $this->addForeignKey(
            'fk-aufzugswarter_tehnic_join-tehnic_id',
            'aufzugswarter_tehnic_join',
            'tehnic_id',
            'tehnical',
            'id',
            'CASCADE'
        );

        // creates index for column `aufzugswarter_id`
        $this->createIndex(
            'idx-aufzugswarter_tehnic_join-aufzugswarter_id',
            'aufzugswarter_tehnic_join',
            'aufzugswarter_id'
        );

        // add foreign key for table `aufzugswarter`
        $this->addForeignKey(
            'fk-aufzugswarter_tehnic_join-aufzugswarter_id',
            'aufzugswarter_tehnic_join',
            'aufzugswarter_id',
            'aufzugswarter',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('aufzugswarter_tehnic_join');
    }

}
