<?php

use yii\db\Migration;

/**
 * Handles the creation of table `tehnic_review`.
 * Has foreign keys to the tables:
 *
 * - `tehnical`
 */
class m170822_113356_create_tehnic_review_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('tehnic_review', [
            'id' => $this->primaryKey(),
            'tehnic_id' => $this->integer()->notNull(),
            'url' => $this->string(),
            'Art' => $this->string(),
            'Prufungsdatum' => $this->string(),
            'datum' => $this->date(),
            'Mangel' => $this->boolean (),
        ]);

        // creates index for column `tehnic_id`
        $this->createIndex(
            'idx-tehnic_review-tehnic_id',
            'tehnic_review',
            'tehnic_id'
        );

        // add foreign key for table `tehnical`
        $this->addForeignKey(
            'fk-tehnic_review-tehnic_id',
            'tehnic_review',
            'tehnic_id',
            'tehnical',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `tehnical`
        $this->dropForeignKey(
            'fk-tehnic_review-tehnic_id',
            'tehnic_review'
        );

        // drops index for column `tehnic_id`
        $this->dropIndex(
            'idx-tehnic_review-tehnic_id',
            'tehnic_review'
        );

        $this->dropTable('tehnic_review');
    }
}
