<?php

use yii\db\Migration;

/**
 * Handles the creation of table `tehnical`.
 * Has foreign keys to the tables:
 *
 * - `user`
 */
class m170820_121655_create_tehnical_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $this->createTable('tehnical', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'Type' => $this->string(),
            'FabriksNr' => $this->string(), 
            'AdresseBundesland' => $this->string(),
            'AdresseOrt' => $this->string(),
            'AdresseStreat' => $this->string(),
            'AdressePLZ' => $this->string(),
            'AdresseStiege' => $this->string(),
            'Baujahr' => $this->string(),
            'Hersteller' => $this->string(),
            'Nennlast' => $this->integer(),
            'Personen' => $this->integer(),
            'Antriebsart' => $this->string(),
            'Nenngeschwindigkeit' => $this->string(),
            'Haltestellen' => $this->string(),
            'Ladestellen' => $this->string(),
            'Hubhohe' => $this->string(),
            'Gesetzt' => $this->string(),
            'Profintervall' => $this->integer(),
            'Betriebskontrollen' => $this->string (),
            'fabric_id' => $this->integer()->notNull(),
            'UmbauName' => $this->string(),
            'UmbauDate' => $this->string(),
            'Umfang' => $this->text(),
            'Letzte' => $this->string(),
            'LetzteDate' => $this->string(),
            'Notizen' => $this->text(),
            'Fakturenadresse' => $this->string(),
            'PreisWP' => $this->string(),
            'evaluierungName' => $this->string(),
            'evaluierungFristen' => $this->date(),
        ]);

        // creates index for column `user_id`
        $this->createIndex(
            'idx-tehnical-user_id',
            'tehnical',
            'user_id'
        );

        // add foreign key for table `user`
        $this->addForeignKey(
            'fk-tehnical-user_id',
            'tehnical',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );

        // creates index for column `fabric_id`
        $this->createIndex(
            'idx-tehnical-fabric_id',
            'tehnical',
            'fabric_id'
        );

        // add foreign key for table `wartungsfirma`
        $this->addForeignKey(
            'fk-tehnical-fabric_id',
            'tehnical',
            'fabric_id',
            'wartungsfirma',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        // drops foreign key for table `user`
        $this->dropForeignKey(
            'fk-tehnical-user_id',
            'tehnical'
        );

        // drops index for column `user_id`
        $this->dropIndex(
            'idx-tehnical-user_id',
            'tehnical'
        );

        // drops foreign key for table `wartungsfirma`
        $this->dropForeignKey(
            'fk-tehnical-fabric_id',
            'tehnical'
        );

        // drops index for column `fabric_id`
        $this->dropIndex(
            'idx-tehnical-fabric_id',
            'tehnical'
        );

        $this->dropTable('tehnical');
    }
}
