<?php

use yii\db\Migration;

class m130524_201442_init extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'username' => $this->string()->notNull()->unique(),
            'auth_key' => $this->string(32)->notNull(),
            'password_hash' => $this->string()->notNull(),
            'password_reset_token' => $this->string()->unique(),
            'email' => $this->string()->notNull()->unique(),
            'first_name' => $this->string(),
            'last_name' => $this->string(),
            'image' => $this->string(),
            'description' => $this->string(),
            'Betreiber' => $this->string(),
            'AdresseBundesland' => $this->string(),
            'AdresseOrt' => $this->string(),
            'AdresseStreat' => $this->string(),
            'AdressePLZ' => $this->string(),
            'AdresseStiege' => $this->string(),
           // 'role_id' => $this->integer()->notNull(),
           // 'company_id' => $this->integer()->notNull(),

            'status' => $this->smallInteger()->notNull()->defaultValue(10),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

  /*      // creates index for column `role_id`
        $this->createIndex(
            'idx-user-role_id',
            'user',
            'role_id'
        );

        // add foreign key for table `roles`
        $this->addForeignKey(
            'fk-user-role_id',
            'user',
            'role_id',
            'roles',
            'id',
            'CASCADE'
        );

        // creates index for column `company_id`
        $this->createIndex(
            'idx-user-company_id',
            'user',
            'company_id'
        );

        // add foreign key for table `companies`
        $this->addForeignKey(
            'fk-user-company_id',
            'user',
            'company_id',
            'companies',
            'id',
            'CASCADE'
        );*/

    }

    public function down()
    {

        // drops foreign key for table `role`
    /*    $this->dropForeignKey(
            'fk-user-role_id',
            'user'
        );

        // drops index for column `role_id`
        $this->dropIndex(
            'idx-user-role_id',
            'user'
        );

        // drops foreign key for table `company`
        $this->dropForeignKey(
            'fk-user-company_id',
            'user'
        );

        // drops index for column `company_id`
        $this->dropIndex(
            'idx-user-company_id',
            'user'
        );*/
        $this->dropTable('{{%user}}');
    }
}
