<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use common\models\Role;
use common\models\Tehnical;
use common\models\Coworker;
use yii\helpers\ArrayHelper;
/**
 * CoworkerFrontendSearch represents the model behind the search form about `common\models\User`.
 */
class UserFrontendSearchGlobal extends User
{

    public $globalSearch;
    public $Role;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['email', 'first_name', 'last_name', 'Telefonnummer', 'AdresseStreat', 'AdresseOrt', 'AdressePLZ', 'Betreiber', 'globalSearch', 'Role'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        #$current_user = User::currentUser();
        #$coworkers = Coworker::find()->where(['company_id' => $current_user->id])->all();
        #$covorkers_ids = ArrayHelper::map($coworkers,'id', 'user_id');


       # $count = $query->count();

       # if ( $query->count() > 0 ) {

       #     $count = $query->count();
       # }else {

       #     $count = 100000;
       # }
        $query = User::find()->joinWith(['role' => function($query) { $query->from(['role' => 'roles']); }]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->orFilterWhere(['like', 'email', $this->globalSearch])
            ->orFilterWhere(['like', 'Telefonnummer', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseStreat', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseOrt', $this->globalSearch])
            ->orFilterWhere(['like', 'AdressePLZ', $this->globalSearch])
            ->orFilterWhere(['like', 'Betreiber', $this->globalSearch])
            ->orFilterWhere(['like', 'last_name', $this->globalSearch])
            ->orFilterWhere(['like', 'role.name', $this->globalSearch]);
        return $dataProvider;
    }
}