<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use common\models\Role;
use common\models\Tehnical;
use common\models\Coworker;
use yii\helpers\ArrayHelper;
/**
 * CoworkerFrontendSearch represents the model behind the search form about `common\models\User`.
 */
class UserBackendCoworkerSearchGlobal extends User
{

    public $globalSearch;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['email', 'first_name', 'last_name', 'Telefonnummer', 'AdresseStreat', 'AdresseOrt', 'AdressePLZ', 'Betreiber', 'globalSearch'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $id = Yii::$app->user->getId();

        if ( $id ) {

            $query = User::find();
        }else {

            $query = null;
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_ASC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->orFilterWhere(['like', 'email', $this->globalSearch])
            ->orFilterWhere(['like', 'Telefonnummer', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseStreat', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseOrt', $this->globalSearch])
            ->orFilterWhere(['like', 'AdressePLZ', $this->globalSearch])
            ->orFilterWhere(['like', 'Betreiber', $this->globalSearch])
            ->orFilterWhere(['like', 'last_name', $this->globalSearch]);
            #->orFilterWhere(['like', 'role.name', $this->globalSearch]);
        return $dataProvider;
    }
}