<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use yii\helpers\ArrayHelper;

/**
 * CoworkerFrontendSearch represents the model behind the search form about `common\models\User`.
 */
class UserBackendCoworkerSearch extends User
{
    /**
     * @inheritdoc
     */
    public $Role;

    public function rules()
    {
        return [
            [['id', 'role_id'], 'integer'],
            [['email', 'first_name', 'last_name', 'Telefonnummer', 'client_password', 'AdresseStreat', 'AdresseOrt', 'AdressePLZ', 'Betreiber', 'Role'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $id = Yii::$app->user->getId();

       	if ( $id ) {

	        $user= User::find()->where(['id' => $id])->one();
	        $kunden_betraibers = $user->getCoworekerPermission()->kunden_betraiber_string_array;
            $kunden_betraibers = unserialize($kunden_betraibers);
	        $users = User::find()->joinWith(['role' => function($query) { $query->from(['role' => 'roles']); }])->where(['user.id' => $kunden_betraibers]);

            $clients_array = ArrayHelper::map($users->all(),'id','Betreiber');
            $clients_unique_array = array_unique($clients_array);

            $query = User::find()->where(['Betreiber' => $clients_unique_array]);

	    }else {

	    	$query = null;
	    }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_ASC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'user.id' => $this->id,
            'user.role_id' => $this->role_id,
            'user.email' => $this->email,
            'user.first_name' => $this->first_name,
            'user.last_name' => $this->last_name,
            'user.Telefonnummer' => $this->Telefonnummer,
        ]);

        $query->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'Telefonnummer', $this->Telefonnummer])
            ->andFilterWhere(['like', 'client_password', $this->client_password])
            ->andFilterWhere(['like', 'AdresseStreat', $this->AdresseStreat])
            ->andFilterWhere(['like', 'AdresseOrt', $this->AdresseOrt])
            ->andFilterWhere(['like', 'AdressePLZ', $this->AdressePLZ])
            ->andFilterWhere(['like', 'Betreiber', $this->Betreiber])
            ->andFilterWhere(['like', 'first_name', $this->first_name])
            ->andFilterWhere(['like', 'last_name', $this->last_name])
            ->andFilterWhere(['like', 'role.name', $this->Role]);
        return $dataProvider;
    }
}