<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use yii\helpers\ArrayHelper;
use common\models\Type;

/**
 * TehinicalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class TehinicalInactiveCoworkerSearch extends Tehnical
{
    /**
     * @inheritdoc
     */
    public $Betreiber;

    public function rules()
    {
        return [
            [['id', 'user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Type', 'FabriksNr', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Baujahr', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen', 'LetzteDate', 'Zusatz', 'Betreiber', 'active'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $id = Yii::$app->user->getId();

       	if ( $id ) {

	        $user= User::find()->where(['id' => $id])->one();
            
            $anlagen_ids = $user->getCoworekerPermission()->anlagen_string;
            $anlagen_ids = unserialize($anlagen_ids);
            
            $query = Tehnical::find()
                ->select('tehnical.*')
                ->leftJoin('user', '`user`.`id` = `tehnical`.`user_id`')
                ->where(['in', ['tehnical.id'],$anlagen_ids])
                ->andWhere(['tehnical.active' => 0])
                ->with('user');
                ;
	    }else {

	    	$query = null;
	    }

        #$query = Tehnical::find()->joinWith(['user' => function($query) { $query->from(['user' => 'user']); }]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'tehnical.id' => $this->id,
            'tehnical.user_id' => $this->user_id,
            'tehnical.Baujahr' => $this->Baujahr,
            'tehnical.Nennlast' => $this->Nennlast,
            'tehnical.Personen' => $this->Personen,
            'tehnical.Profintervall' => $this->Profintervall,
        ]);

        $query->andFilterWhere(['like', 'tehnical.id', $this->id])
            ->andFilterWhere(['like', 'tehnical.Type', $this->Type])
            ->andFilterWhere(['like', 'tehnical.FabriksNr', $this->FabriksNr])
            ->andFilterWhere(['like', 'tehnical.AdresseBundesland', $this->AdresseBundesland])
            ->andFilterWhere(['like', 'tehnical.AdresseOrt', $this->AdresseOrt])
            ->andFilterWhere(['like', 'tehnical.AdresseStreat', $this->AdresseStreat])
            ->andFilterWhere(['like', 'tehnical.AdressePLZ', $this->AdressePLZ])
            ->andFilterWhere(['like', 'tehnical.AdresseStiege', $this->AdresseStiege])
            ->andFilterWhere(['like', 'tehnical.Hersteller', $this->Hersteller])
            ->andFilterWhere(['like', 'tehnical.Antriebsart', $this->Antriebsart])
            ->andFilterWhere(['like', 'tehnical.Nenngeschwindigkeit', $this->Nenngeschwindigkeit])
            ->andFilterWhere(['like', 'tehnical.Haltestellen', $this->Haltestellen])
            ->andFilterWhere(['like', 'tehnical.Ladestellen', $this->Ladestellen])
            ->andFilterWhere(['like', 'tehnical.Hubhohe', $this->Hubhohe])
            ->andFilterWhere(['like', 'tehnical.Gesetzt', $this->Gesetzt])
            ->andFilterWhere(['like', 'tehnical.Betriebskontrollen', $this->Betriebskontrollen])
            ->andFilterWhere(['like', 'tehnical.Zusatz', $this->Zusatz])
            ->andFilterWhere(['like', 'tehnical.LetzteDate', $this->LetzteDate])
            ->andFilterWhere(['like', 'user.Betreiber', $this->Betreiber]);

            return $dataProvider;
    }
}