<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;

/**
 * TehinicalGlobalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class TehinicalGlobalBackendSearch extends Tehnical
{

    public $globalSearch;
    public $Betreiber;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Type', 'FabriksNr', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Baujahr', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen', 'globalSearch', 'ObjektNr', 'Zusatz', 'LetzteDate', 'Betreiber'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $query = Tehnical::find()->joinWith(['user' => function($query) { $query->from(['user' => 'user']); }]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
            //'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        $query->orFilterWhere(['like', 'tehnical.Type', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.FabriksNr', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.AdresseBundesland', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.AdresseOrt', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.AdresseStreat', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.AdressePLZ', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.AdresseStiege', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.Hersteller', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.Gesetzt', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.ObjektNr', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.Zusatz', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.id', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.LetzteDate', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.Betriebskontrollen', $this->globalSearch])
            ->orFilterWhere(['like', 'user.Betreiber', $this->globalSearch]);

        return $dataProvider;
    }
}
