<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use yii\helpers\ArrayHelper;
use common\models\Type;
use yii\data\Pagination;
/**
 * TehinicalGlobalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class TehinicalCoworkerGlobalBackendSearch extends Tehnical
{

    public $globalSearch;
    public $Betreiber;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Type', 'FabriksNr', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Baujahr', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen', 'globalSearch', 'ObjektNr', 'Zusatz', 'LetzteDate', 'Betreiber'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $id = Yii::$app->user->getId();

        if ( $id ) {

            #    $query = Tehnical::find()->joinWith(['user' => function($query) { $query->from(['user' => 'user']); }]);

            $user= User::find()->where(['id' => $id])->one();
            
            $anlagen_ids = $user->getCoworekerPermission()->anlagen_string;
            $anlagen_ids = unserialize($anlagen_ids);
            $ids = implode(",", $anlagen_ids);
            $offset = 0;


            if(isset($_GET["page"])) {
                $offset = $_GET["page"];
            }

            if( $offset == 1 || $offset == 0) {
                $offset = 0;
            }else {
                $offset = ( $offset  - 1 )* 20;
            }

            $sql2 = "";

            if(  isset($_GET['TehinicalCoworkerGlobalBackendSearch']) && isset($_GET['TehinicalCoworkerGlobalBackendSearch']['globalSearch']) )
            {
                $params = $_GET['TehinicalCoworkerGlobalBackendSearch']["globalSearch"];


                $sql2 = "
                    AND
                    (
                        
                            (
                                t.Type LIKE '".$params."%'
                            )
                        OR
                            (
                                t.FabriksNr LIKE '".$params."%'
                            )
                        OR
                            (
                                t.AdresseBundesland LIKE '".$params."%'
                            )
                        OR
                            (
                                t.AdresseOrt LIKE '".$params."%'
                            )
                        OR
                            (

                                t.AdresseStreat LIKE '".$params."%'
                            )
                        OR
                            (
                                t.AdressePLZ LIKE '".$params."%'
                            )
                        OR
                            (
                                t.AdresseStiege LIKE '".$params."%'
                            )
                        OR
                            (
                                t.Hersteller LIKE '".$params."%'
                            )
                        OR
                            (
                                t.Gesetzt LIKE '".$params."%'
                            )
                        OR
                            (
                                t.ObjektNr LIKE '".$params."%'
                            )
                        OR
                            (
                                t.Zusatz LIKE '".$params."%'
                            )
                        OR
                            (
                                t.id LIKE '".$params."%'
                            )
                        OR
                            (
                                t.LetzteDate LIKE '".$params."%'
                            )
                        OR
                            (
                                t.Betriebskontrollen LIKE '".$params."%'
                            )
                        OR
                            (
                                u.Betreiber LIKE '".$params."%'
                            )
                    )    
                ";
            }

            $sql= "SELECT 
                        t.*, 
                        u.Betreiber
                    FROM 
                        tehnical t
                    LEFT JOIN
                        user u
                    ON
                        u.id = t.user_id
                    WHERE t.id IN ($ids)
                    $sql2
                    ORDER BY 
                        id desc
                    LIMIT 20
                    OFFSET $offset
                    ";

                    $query = Tehnical::findBySql($sql);
        }else {

            $query = null;
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);


        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        return $dataProvider;
    }
}
