<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\TehnicReview;

/**
 * TehinicReviewSearch represents the model behind the search form about `common\models\TehnicReview`.
 */
class TehinicReviewSearch extends TehnicReview
{

    public $Type;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tehnic_id', 'Mangel'], 'integer'],
            [['url', 'Art', 'Prufungsdatum', 'datum', 'Type'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
       # $query = TehnicReview::find();

        $query = TehnicReview::find()->joinWith(['tehnic' => function($query) { $query->from(['tehnical' => 'tehnical']); }]);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'tehnic_review->id' => $this->id,
            'tehnic_review->tehnic_id' => $this->tehnic_id,
            'tehnic_review->Mangel' => $this->Mangel,
        ]);

        $query->andFilterWhere(['like', 'url', $this->url])
            ->andFilterWhere(['like', 'Art', $this->Art])
            ->andFilterWhere(['like', 'Prufungsdatum', $this->Prufungsdatum])
            ->andFilterWhere(['like', 'datum', $this->datum])
            ->andFilterWhere(['like', 'tehnical.type', $this->Type]);

        return $dataProvider;
    }
}
