<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use common\models\TehnicReview;
use yii\helpers\ArrayHelper;
use common\models\Type;
/**
 * TehinicalGlobalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class TehinicReviewGlobalCoworkerBackendSearch extends TehnicReview
{

    public $globalSearch;
    public $Type;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tehnic_id', 'Mangel'], 'integer'],
            [['url', 'Art', 'Prufungsdatum', 'datum', 'globalSearch', 'Type'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $id = Yii::$app->user->getId();

        if ( $id ) {

            //$query = TehnicReview::find()->joinWith(['tehnic' => function($query) { $query->from(['tehnical' => 'tehnical']); }]);
        
            $user= User::find()->where(['id' => $id])->one();
            
            $anlagen_ids = $user->getCoworekerPermission()->anlagen_string;
            $anlagen_ids = unserialize($anlagen_ids);
            $ids = implode(", ", $anlagen_ids);
            $offset = 0;


            if(isset($_GET["page"])) {
                $offset = $_GET["page"];
            }

            if( $offset == 1 || $offset == 0) {
                $offset = 0;
            }else {
                $offset = ( $offset  - 1 )* 20;
            }


            $sql2 = "";

            if(  isset($_GET['TehinicReviewGlobalCoworkerBackendSearch']) && isset($_GET['TehinicReviewGlobalCoworkerBackendSearch']['globalSearch']) )
            {
                $params = $_GET['TehinicReviewGlobalCoworkerBackendSearch']["globalSearch"];

                 $sql2 = "
                    AND
                    (
                        
                            (
                                tr.url LIKE '".$params."%'
                            )
                        OR
                            (
                                tr.Art LIKE '".$params."%'
                            )
                        OR
                            (
                                tr.Prufungsdatum LIKE '".$params."%'
                            )
                        OR
                            (
                                tr.datum LIKE '".$params."%'
                            )
                        OR
                            (
                                t.type LIKE '".$params."%'
                            )
                    )";
            }

            $sql="
                SELECT tr.*,
                t.type
                FROM 
                    tehnic_review tr
               LEFT JOIN
                tehnical t
               ON
                tr.tehnic_id = t.id
               WHERE
                tr.tehnic_id IN ($ids)
                $sql2
                GROUP BY 
                    tr.id
                ORDER BY 
                    tr.id DESC
                LIMIT 
                    20
                OFFSET 
                    $offset";

            $query = TehnicReview::findBySql($sql);

        }else {

            $query = null;
        }
    #    $query = TehnicReview::find()->joinWith(['tehnic' => function($query) { $query->from(['tehnical' => 'tehnical']); }]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        return $dataProvider;
    }
}
