<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use common\models\TehnicReview;

/**
 * TehinicalGlobalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class TehinicReviewGlobalBackendSearch extends TehnicReview
{

    public $globalSearch;
    public $Type;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tehnic_id', 'Mangel'], 'integer'],
            [['url', 'Art', 'Prufungsdatum', 'datum', 'globalSearch', 'Type'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

    #    $query = TehnicReview::find();

        $query = TehnicReview::find()->joinWith(['tehnic' => function($query) { $query->from(['tehnical' => 'tehnical']); }]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }


        $query->orFilterWhere(['like', 'url', $this->globalSearch])
            ->orFilterWhere(['like', 'Art', $this->globalSearch])
            ->orFilterWhere(['like', 'Prufungsdatum', $this->globalSearch])
            ->orFilterWhere(['like', 'datum', $this->globalSearch])
            ->orFilterWhere(['like', 'tehnical.type', $this->globalSearch]);

        return $dataProvider;
    }
}
