<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\TehnicReview;
use common\models\Tehnical;
use common\models\User;
use yii\helpers\ArrayHelper;
use common\models\Type;

/**
 * TehinicReviewSearch represents the model behind the search form about `common\models\TehnicReview`.
 */
class TehinicReviewBackendCoworkerSearch extends TehnicReview
{

    public $Type;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'tehnic_id', 'Mangel'], 'integer'],
            [['url', 'Art', 'Prufungsdatum', 'datum', 'Type'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $id = Yii::$app->user->getId();

        if ( $id ) {


            $user= User::find()->where(['id' => $id])->one();
            
            $anlagen_ids = $user->getCoworekerPermission()->anlagen_string;
            $anlagen_ids = unserialize($anlagen_ids);
            
            $query = TehnicReview::find()
                ->select('tehnic_review.*')
                ->leftJoin('tehnical', '`tehnical`.`id` = `tehnic_review`.`tehnic_id`')
                ->where(['in', ['tehnic_review.tehnic_id'],$anlagen_ids])
                ->with('tehnical');
                ;

        }else {

            $query = null;
        }
        
     #   $query = TehnicReview::find()->joinWith(['tehnic' => function($query) { $query->from(['tehnical' => 'tehnical']); }]);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'tehnic_review->id' => $this->id,
            'tehnic_review->tehnic_id' => $this->tehnic_id,
            'tehnic_review->Mangel' => $this->Mangel,
        ]);

        $query->andFilterWhere(['like', 'url', $this->url])
            ->andFilterWhere(['like', 'Art', $this->Art])
            ->andFilterWhere(['like', 'Prufungsdatum', $this->Prufungsdatum])
            ->andFilterWhere(['like', 'datum', $this->datum])
            ->andFilterWhere(['like', 'tehnical.type', $this->Type]);

        return $dataProvider;
    }
}
