<?php


namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\InvoiceData;
/**

use Yii;

/**
 * This is the model class for table "invoice_data".
 *
 * @property integer $id
 * @property string $KundenNr
 * @property string $Kunden_Rechnungszusatz
 * @property string $Kunden_Strase
 * @property string $Kunden_PLZ
 * @property string $Kunden_Ort
 * @property string $Kunden_Referenzzeilec
 * @property string $Kunden_Rechnungsemail
 */

class InvoiceDataSearch extends InvoiceData
{

    /**
     * @inheritdoc
     */

    public function rules()
    {
        return [
            [['KundenNr'], 'safe'],
            [['KundenNr', 'Kunden_Rechnungszusatz', 'Kunden_Strase', 'Kunden_PLZ', 'Kunden_Ort', 'Kunden_Referenzzeilec', 'Kunden_Rechnungsemail', 'Kunden_Rechnungszusatz'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    public function search($params)
    {

        $query = InvoiceData::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_ASC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'invoice_data.id' => $this->id,
            'invoice_data.KundenNr' => $this->KundenNr,
            'invoice_data.Kunden_Rechnungszusatz' => $this->Kunden_Rechnungszusatz,
            'invoice_data.Kunden_Strase' => $this->Kunden_Strase,
            'invoice_data.Kunden_PLZ' => $this->Kunden_PLZ,
            'invoice_data.Kunden_Ort' => $this->Kunden_Ort,
            'invoice_data.Kunden_Referenzzeilec' => $this->Kunden_Referenzzeilec,
            'invoice_data.Kunden_Rechnungsemail' => $this->Kunden_Rechnungsemail
        ]);

        $query->andFilterWhere(['like', 'KundenNr', $this->KundenNr])
            ->andFilterWhere(['like', 'Kunden_Rechnungszusatz', $this->Kunden_Rechnungszusatz])
            ->andFilterWhere(['like', 'Kunden_Strase', $this->Kunden_Strase])
            ->andFilterWhere(['like', 'Kunden_PLZ', $this->Kunden_PLZ])
            ->andFilterWhere(['like', 'Kunden_Ort', $this->Kunden_Ort])
            ->andFilterWhere(['like', 'Kunden_Referenzzeilec', $this->Kunden_Referenzzeilec]);
        return $dataProvider;
    }
}
