<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use common\models\Tehnical;
use common\models\Coworker;
use yii\helpers\ArrayHelper;
/**
 * CoworkerFrontendSearch represents the model behind the search form about `common\models\User`.
 */
class CoworkerFrontendGlobalSearch extends User
{

    public $globalSearch;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['email', 'first_name', 'last_name', 'Telefonnummer', 'globalSearch'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        #$current_user = User::currentUser();
        #$coworkers = Coworker::find()->where(['company_id' => $current_user->id])->all();
        #$covorkers_ids = ArrayHelper::map($coworkers,'id', 'user_id');

        $query = User::find();#->where(['in', 'id', $covorkers_ids]);


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->orFilterWhere(['like', 'email', $this->globalSearch])
            ->orFilterWhere(['like', 'Telefonnummer', $this->globalSearch])
            ->orFilterWhere(['like', 'first_name', $this->globalSearch])
            ->orFilterWhere(['like', 'last_name', $this->globalSearch]);
        return $dataProvider;
    }
}