<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use common\models\Coworker;

/**
 * TehinicalGlobalSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class AnlagenGlobalSearch extends Tehnical
{

    public $globalSearch;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Type', 'FabriksNr', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Baujahr', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen', 'globalSearch', 'ObjektNr', 'Zusatz'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $current_user = User::currentUser();

        $coworker = Coworker::find()->where(['user_id' => $current_user->id])->one();

        $company = $coworker->getCompany()->one();

        if ( $company && $company->getTehnicals()) {

            $query = $company->getTehnicals();
        }else {

            $query = null;
        }

       // $query = Tehnical::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['new_prufungen_date_time' => SORT_DESC, 'id' => SORT_DESC]],
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions


        $query->orFilterWhere(['like', 'Type', $this->globalSearch])
            ->orFilterWhere(['like', 'FabriksNr', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseBundesland', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseOrt', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseStreat', $this->globalSearch])
            ->orFilterWhere(['like', 'AdressePLZ', $this->globalSearch])
            ->orFilterWhere(['like', 'AdresseStiege', $this->globalSearch])
            ->orFilterWhere(['like', 'Hersteller', $this->globalSearch])
            ->orFilterWhere(['like', 'Antriebsart', $this->globalSearch])
            ->orFilterWhere(['like', 'Nenngeschwindigkeit', $this->globalSearch])
            ->orFilterWhere(['like', 'Haltestellen', $this->globalSearch])
            ->orFilterWhere(['like', 'Ladestellen', $this->globalSearch])
            ->orFilterWhere(['like', 'Hubhohe', $this->globalSearch])
            ->orFilterWhere(['like', 'Gesetzt', $this->globalSearch])
            ->orFilterWhere(['like', 'ObjektNr', $this->globalSearch])
            ->orFilterWhere(['like', 'Zusatz', $this->globalSearch])
            ->orFilterWhere(['like', 'Betriebskontrollen', $this->globalSearch]);

        return $dataProvider;
    }
}