<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Tehnical;
use common\models\User;
use common\models\Coworker;

/**
 * TehinicalFrontendSearch represents the model behind the search form about `common\models\Tehnical`.
 */
class AnlagenFrontendSearch extends Tehnical
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Type', 'FabriksNr', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Baujahr', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen', 'ObjektNr', 'Zusatz'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $current_user = User::currentUser();

        $coworker = Coworker::find()->where(['user_id' => $current_user->id])->one();

        $company = $coworker->getCompany()->one();

        if ( $company && $company->getTehnicals()) {

            $query = $company->getTehnicals();
        }else {

            $query = null;
        }

       // $query = Tehnical::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['new_prufungen_date_time' => SORT_DESC, 'id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'Baujahr' => $this->Baujahr,
            'Nennlast' => $this->Nennlast,
            'Personen' => $this->Personen,
            'Profintervall' => $this->Profintervall,
        ]);

        $query->andFilterWhere(['like', 'Type', $this->Type])
            ->andFilterWhere(['like', 'FabriksNr', $this->FabriksNr])
            ->andFilterWhere(['like', 'AdresseBundesland', $this->AdresseBundesland])
            ->andFilterWhere(['like', 'AdresseOrt', $this->AdresseOrt])
            ->andFilterWhere(['like', 'AdresseStreat', $this->AdresseStreat])
            ->andFilterWhere(['like', 'AdressePLZ', $this->AdressePLZ])
            ->andFilterWhere(['like', 'AdresseStiege', $this->AdresseStiege])
            ->andFilterWhere(['like', 'Hersteller', $this->Hersteller])
            ->andFilterWhere(['like', 'Antriebsart', $this->Antriebsart])
            ->andFilterWhere(['like', 'Nenngeschwindigkeit', $this->Nenngeschwindigkeit])
            ->andFilterWhere(['like', 'Haltestellen', $this->Haltestellen])
            ->andFilterWhere(['like', 'Ladestellen', $this->Ladestellen])
            ->andFilterWhere(['like', 'Hubhohe', $this->Hubhohe])
            ->andFilterWhere(['like', 'Gesetzt', $this->Gesetzt])
            ->andFilterWhere(['like', 'ObjektNr', $this->ObjektNr])
            ->andFilterWhere(['like', 'Zusatz', $this->Zusatz])
            ->andFilterWhere(['like', 'Betriebskontrollen', $this->Betriebskontrollen]);

        return $dataProvider;
    }
}