<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
/**
 * CoworkerFrontendSearch represents the model behind the search form about `common\models\User`.
 */
class AdminCoworkerSearch extends User
{
    /**
     * @inheritdoc
     */

    public function rules()
    {
        return [
            [['id', 'role_id'], 'integer'],
            [['email', 'first_name', 'last_name', 'Telefonnummer', 'client_password', 'AdresseStreat', 'AdresseOrt', 'AdressePLZ', 'Betreiber'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {

        $query = User::find()->where(['role_id' => 4]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['id' => SORT_ASC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'user.id' => $this->id,
            'user.email' => $this->email,
            'user.first_name' => $this->first_name,
            'user.last_name' => $this->last_name,
            'user.Telefonnummer' => $this->Telefonnummer,
        ]);

        $query->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'Telefonnummer', $this->Telefonnummer])
            ->andFilterWhere(['like', 'client_password', $this->client_password])
            ->andFilterWhere(['like', 'AdresseStreat', $this->AdresseStreat])
            ->andFilterWhere(['like', 'AdresseOrt', $this->AdresseOrt])
            ->andFilterWhere(['like', 'AdressePLZ', $this->AdressePLZ])
            ->andFilterWhere(['like', 'Betreiber', $this->Betreiber])
            ->andFilterWhere(['like', 'first_name', $this->first_name])
            ->andFilterWhere(['like', 'last_name', $this->last_name]);
        return $dataProvider;
    }
}