<?php

namespace common\models\data_base_models;

use Yii;

/**
 * This is the model class for table "{{%build_ios}}".
 *
 * @property integer $id
 * @property string $name
 * @property string $data
 * @property string $description
 * @property integer $ios_id
 *
 * @property Ios $ios
 */
class dbBuildIos extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%build_ios}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['ios_id', 'name', 'binary_number'], 'required'],
            [['ios_id'], 'integer'],
            [['description'], 'string', 'max' => 455],
            [['ios_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbIos::className(), 'targetAttribute' => ['ios_id' => 'id']],
            [['data'], 'safe'],
            [['data'], 'required', 'on' => 'create'],
            ['data', 'file', 'extensions'=>'ipa'],
            [['created_at'], 'safe'],
            [['image_1'], 'safe'],
            ['image_1', 'image', 'minWidth' => 57, 'maxWidth' => 57,'minHeight' => 57, 'maxHeight' => 57, 'extensions'=>'jpg, png, jpeg'],
            [['image_2'], 'safe'],
            ['image_2', 'image', 'minWidth' => 512, 'maxWidth' => 512,'minHeight' => 512, 'maxHeight' => 512, 'extensions'=>'jpg, png, jpeg'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Version',
            'data' => 'Data',
            'description' => 'Description',
            'ios_id' => 'Ios ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIos()
    {
        return $this->hasOne(Ios::className(), ['id' => 'ios_id']);
    }
}
