<?php

namespace common\models\data_base_models;

use Yii;

/**
 * This is the model class for table "{{%build_android}}".
 *
 * @property integer $id
 * @property string $name
 * @property string $data
 * @property string $description
 * @property integer $android_id
 *
 * @property Androids $android
 */
class dbBuildAndroid extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%build_android}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['android_id', 'name', 'binary_number'], 'required'],
            [['android_id'], 'integer'],
            [['description'], 'string', 'max' => 455],
            [['android_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbAndroid::className(), 'targetAttribute' => ['android_id' => 'id']],
            [['created_at'], 'safe'],
            [['image_1'], 'safe'],
            ['image_1', 'image', 'minWidth' => 512, 'maxWidth' => 512,'minHeight' => 512, 'maxHeight' => 512, 'extensions'=>'jpg, png, jpeg'],

            [['image_2'], 'safe'],
            ['image_2', 'image', 'minWidth' => 1024, 'maxWidth' => 1024,'minHeight' => 500, 'maxHeight' => 500, 'extensions'=>'jpg, png, jpeg'],
         //   ['data', 'file', 'extensions'=>'apk'],
        ];
    }


    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Version',
            'data' => 'Data',
            'description' => 'Description',
            'android_id' => 'Android ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAndroid()
    {
        return $this->hasOne(Androids::className(), ['id' => 'android_id']);
    }
}
