<?php

namespace common\models\data_base_models;

use Yii;

/**
 * This is the model class for table "{{%builds}}".
 *
 * @property integer $id
 * @property string $name
 * @property string $data
 * @property string $description
 * @property integer $android_id
 * @property integer $ios_id
 *
 * @property Androids $android
 * @property Ios $ios
 */
class dbBuild extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%builds}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['android_id', 'ios_id'], 'required'],
            [['android_id', 'ios_id'], 'integer'],
            [['name', 'data'], 'string', 'max' => 255],
            [['android_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbAndroid::className(), 'targetAttribute' => ['android_id' => 'id']],
            [['ios_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbIos::className(), 'targetAttribute' => ['ios_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'data' => 'Data',
            'description' => 'Description',
            'android_id' => 'Android ID',
            'ios_id' => 'Ios ID',
        ];
    }
}
