<?php

namespace common\models\data_base_models;

use Yii;

/**
 * This is the model class for table "{{%applications}}".
 *
 * @property integer $id
 * @property string $name
 * @property string $application_type
 * @property integer $company_id
 *
 * @property Androids[] $androids
 * @property Companies $company
 * @property Ios[] $ios
 */
class dbApplication extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%applications}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['company_id'], 'required'],
            [['user_name', 'application_type', 'name'], 'required'],
            [['company_id'], 'integer'],
            [['name', 'application_type'], 'string', 'max' => 255],
            [['company_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbCompany::className(), 'targetAttribute' => ['company_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'application_type' => 'Platform',
            'company_id' => 'Company ID',
        ];
    }
}
