<?php

namespace common\models\data_base_models;

use Yii;

/**
 * This is the model class for table "{{%amazon}}".
 *
 * @property integer $id
 * @property string $data
 * @property integer $build_android_id
 *
 * @property BuildAndroid $buildAndroid
 */
class dbAmazon extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%amazon}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['build_android_id'], 'integer'],
            [['build_android_id'], 'exist', 'skipOnError' => true, 'targetClass' => dbBuildAndroid::className(), 'targetAttribute' => ['build_android_id' => 'id']],
            ['data', 'safe'],
            [['data'], 'required', 'on' => 'requiredAmazon'],
            ['data', 'file', 'extensions'=>'apk'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'data' => 'Data',
            'build_android_id' => 'Build Android ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBuildAndroid()
    {
        return $this->hasOne(dbBuildAndroid::className(), ['id' => 'build_android_id']);
    }
}
