<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%wartungsart}}".
 *
 * @property integer $id
 * @property string $name
 */
class Wartungsart extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%wartungsart}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 12],
            [['name'], 'unique'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    public function getTehnicals()
    {
        return $this->hasMany(Tehnical::className(), ['fabric_id' => 'id']);
    }
}
