<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "user_anlagen_coworker_control".
 *
 * @property integer $id
 * @property integer $user_id
 * @property integer $anlagen_id
 * @property string $token
 * @property string $client_secret
 * @property string $name
 * @property string $title
 *
 * @property Tehnical $anlagen
 * @property CoworkerControll $control
 * @property User $user
 */
class UserAnlagenCoworkerControl extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_anlagen_coworker_control';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'anlagen_id'], 'required'],
            [['control_id'], 'safe'],
            [['user_id', 'anlagen_id', 'allowAnotherUserAccessAnlagen'], 'integer'],
            [['anlagen_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tehnical::className(), 'targetAttribute' => ['anlagen_id' => 'id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'anlagen_id' => 'Anlagen ID',
            'control_id' => 'Control ID',
            'allowAnotherUserAccessAnlagen' => 'allowAnotherUserAccessAnlagen',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function gettehnical()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'anlagen_id']);
    }



    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
