<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tehnical_document".
 *
 * @property integer $id
 * @property integer $tehnical_id
 * @property string $url
 *
 * @property Tehnical $tehnical
 */
class TehnicalDocument extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public $files;
    public static function tableName()
    {
        return 'tehnical_document';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tehnical_id', 'url'], 'required'],
            [['tehnical_id'], 'integer'],
            [['files'], 'safe'],
            [['files'], 'file', 'extensions' => 'jpg, png, jpeg, pdf, doc, xls, docx, xlsx', 'maxFiles' => 10],
            [['url'], 'string', 'max' => 200],
            [['url'], 'unique'],
            [['tehnical_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tehnical::className(), 'targetAttribute' => ['tehnical_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tehnical_id' => 'Tehnical ID',
            'url' => 'Url',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTehnical()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'tehnical_id']);
    }
}
